/*
 * Decompiled with CFR 0.152.
 */
package hu.uw.pallergabor.dedexer;

import hu.uw.pallergabor.dedexer.CodeGenerator;
import hu.uw.pallergabor.dedexer.DedexerTask;
import hu.uw.pallergabor.dedexer.DexClassDefsBlock;
import hu.uw.pallergabor.dedexer.DexFieldIdsBlock;
import hu.uw.pallergabor.dedexer.DexMethodIdsBlock;
import hu.uw.pallergabor.dedexer.DexOffsetResolver;
import hu.uw.pallergabor.dedexer.DexParser;
import hu.uw.pallergabor.dedexer.DexSignatureBlock;
import hu.uw.pallergabor.dedexer.DexStringIdsBlock;
import hu.uw.pallergabor.dedexer.DexTypeIdsBlock;
import hu.uw.pallergabor.dedexer.FillArrayTask;
import hu.uw.pallergabor.dedexer.LabelTask;
import hu.uw.pallergabor.dedexer.PackedSwitchTask;
import hu.uw.pallergabor.dedexer.RegisterTraces;
import hu.uw.pallergabor.dedexer.SparseSwitchTask;
import hu.uw.pallergabor.dedexer.TaskCollection;
import hu.uw.pallergabor.dedexer.UnknownInstructionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class DexInstructionParser
extends DexParser {
    public static final Integer REGMAP_RESULT_KEY = new Integer(-1);
    public static final String TYPE_SINGLE_LENGTH = "single-length";
    public static final String TYPE_DOUBLE_LENGTH = "double-length";
    public static final String TYPE_UNKNOWN = "unknown";
    private DexSignatureBlock dexSignatureBlock = null;
    private DexStringIdsBlock dexStringIdsBlock = null;
    private DexTypeIdsBlock dexTypeIdsBlock = null;
    private DexFieldIdsBlock dexFieldIdsBlock = null;
    private DexMethodIdsBlock dexMethodIdsBlock = null;
    private DexOffsetResolver dexOffsetResolver = null;
    private InstructionType[] instructionTypes = new InstructionType[]{InstructionType.NOPARAMETER, InstructionType.MOVE, InstructionType.REG8REG16, InstructionType.REG16REG16, InstructionType.MOVE, InstructionType.REG8REG16, InstructionType.REG16REG16, InstructionType.MOVE_OBJECT, InstructionType.REG8REG16_OBJECT, InstructionType.REG16REG16_OBJECT, InstructionType.MOVERESULT, InstructionType.MOVERESULT, InstructionType.MOVERESULT, InstructionType.MOVERESULT, InstructionType.NOPARAMETER, InstructionType.ONEREG, InstructionType.ONEREG, InstructionType.ONEREG, InstructionType.REGCONST4, InstructionType.REGCONST16, InstructionType.REGCONST32, InstructionType.REGCONST16, InstructionType.REGCONST16_WIDE, InstructionType.REGCONST32_WIDE, InstructionType.REGCONST64, InstructionType.REGCONST16_WIDE, InstructionType.REGSTRINGCONST, InstructionType.REGSTRINGCONST_JUMBO, InstructionType.REGCLASSCONST, InstructionType.ONEREG, InstructionType.ONEREG, InstructionType.CHECKCAST, InstructionType.TWOREGSTYPE, InstructionType.TWOREGSPACKED_SINGLE, InstructionType.NEWINSTANCE, InstructionType.NEWARRAY, InstructionType.FILLEDARRAY, InstructionType.FILLEDARRAY_RANGE, InstructionType.FILLARRAYDATA, InstructionType.ONEREG, InstructionType.OFFSET8, InstructionType.OFFSET16, InstructionType.UNKNOWN_INSTRUCTION, InstructionType.PACKEDSWITCH, InstructionType.SPARSESWITCH, InstructionType.THREEREGS, InstructionType.THREEREGS, InstructionType.THREEREGS, InstructionType.THREEREGS, InstructionType.THREEREGS, InstructionType.TWOREGSOFFSET16, InstructionType.TWOREGSOFFSET16, InstructionType.TWOREGSOFFSET16, InstructionType.TWOREGSOFFSET16, InstructionType.TWOREGSOFFSET16, InstructionType.TWOREGSOFFSET16, InstructionType.REGOFFSET16, InstructionType.REGOFFSET16, InstructionType.REGOFFSET16, InstructionType.REGOFFSET16, InstructionType.REGOFFSET16, InstructionType.REGOFFSET16, InstructionType.UNKNOWN_INSTRUCTION, InstructionType.UNKNOWN_INSTRUCTION, InstructionType.UNKNOWN_INSTRUCTION, InstructionType.UNKNOWN_INSTRUCTION, InstructionType.UNKNOWN_INSTRUCTION, InstructionType.UNKNOWN_INSTRUCTION, InstructionType.AGET, InstructionType.AGET, InstructionType.AGET, InstructionType.AGET, InstructionType.AGET, InstructionType.AGET, InstructionType.AGET, InstructionType.APUT, InstructionType.APUT, InstructionType.APUT, InstructionType.APUT, InstructionType.APUT, InstructionType.APUT, InstructionType.APUT, InstructionType.TWOREGSFIELD_READ, InstructionType.TWOREGSFIELD_READ_WIDE, InstructionType.TWOREGSFIELD_READ_OBJECT, InstructionType.TWOREGSFIELD_READ, InstructionType.TWOREGSFIELD_READ, InstructionType.TWOREGSFIELD_READ, InstructionType.TWOREGSFIELD_READ, InstructionType.TWOREGSFIELD_WRITE, InstructionType.TWOREGSFIELD_WRITE, InstructionType.TWOREGSFIELD_WRITE, InstructionType.TWOREGSFIELD_WRITE, InstructionType.TWOREGSFIELD_WRITE, InstructionType.TWOREGSFIELD_WRITE, InstructionType.TWOREGSFIELD_WRITE, InstructionType.ONEREGFIELD_READ, InstructionType.ONEREGFIELD_READ_WIDE, InstructionType.ONEREGFIELD_READ_OBJECT, InstructionType.ONEREGFIELD_READ, InstructionType.ONEREGFIELD_READ, InstructionType.ONEREGFIELD_READ, InstructionType.ONEREGFIELD_READ, InstructionType.ONEREGFIELD_WRITE, InstructionType.ONEREGFIELD_WRITE, InstructionType.ONEREGFIELD_WRITE, InstructionType.ONEREGFIELD_WRITE, InstructionType.ONEREGFIELD_WRITE, InstructionType.ONEREGFIELD_WRITE, InstructionType.ONEREGFIELD_WRITE, InstructionType.METHODINVOKE, InstructionType.METHODINVOKE, InstructionType.METHODINVOKE, InstructionType.METHODINVOKE_STATIC, InstructionType.METHODINVOKE, InstructionType.UNKNOWN_INSTRUCTION, InstructionType.METHODINVOKE_RANGE, InstructionType.METHODINVOKE_RANGE, InstructionType.METHODINVOKE_RANGE, InstructionType.METHODINVOKE_RANGE_STATIC, InstructionType.METHODINVOKE_RANGE, InstructionType.UNKNOWN_INSTRUCTION, InstructionType.UNKNOWN_INSTRUCTION, InstructionType.TWOREGSPACKED_SINGLE, InstructionType.UNKNOWN_INSTRUCTION, InstructionType.TWOREGSPACKED_DOUBLE, InstructionType.UNKNOWN_INSTRUCTION, InstructionType.TWOREGSPACKED_SINGLE, InstructionType.TWOREGSPACKED_DOUBLE, InstructionType.TWOREGSPACKED_DOUBLE, InstructionType.TWOREGSPACKED_SINGLE, InstructionType.TWOREGSPACKED_DOUBLE, InstructionType.TWOREGSPACKED_SINGLE, InstructionType.TWOREGSPACKED_SINGLE, InstructionType.TWOREGSPACKED_DOUBLE, InstructionType.TWOREGSPACKED_SINGLE, InstructionType.TWOREGSPACKED_DOUBLE, InstructionType.TWOREGSPACKED_DOUBLE, InstructionType.TWOREGSPACKED_SINGLE, InstructionType.TWOREGSPACKED_DOUBLE, InstructionType.TWOREGSPACKED_SINGLE, InstructionType.TWOREGSPACKED_SINGLE, InstructionType.TWOREGSPACKED_SINGLE, InstructionType.TWOREGSPACKED_SINGLE, InstructionType.THREEREGS, InstructionType.THREEREGS, InstructionType.THREEREGS, InstructionType.THREEREGS, InstructionType.THREEREGS, InstructionType.THREEREGS, InstructionType.THREEREGS, InstructionType.THREEREGS, InstructionType.THREEREGS, InstructionType.THREEREGS, InstructionType.THREEREGS, InstructionType.THREEREGS_WIDE, InstructionType.THREEREGS_WIDE, InstructionType.THREEREGS_WIDE, InstructionType.THREEREGS_WIDE, InstructionType.THREEREGS_WIDE, InstructionType.THREEREGS_WIDE, InstructionType.THREEREGS_WIDE, InstructionType.THREEREGS_WIDE, InstructionType.THREEREGS_WIDE, InstructionType.THREEREGS_WIDE, InstructionType.THREEREGS_WIDE, InstructionType.THREEREGS, InstructionType.THREEREGS, InstructionType.THREEREGS, InstructionType.THREEREGS, InstructionType.THREEREGS, InstructionType.THREEREGS_WIDE, InstructionType.THREEREGS_WIDE, InstructionType.THREEREGS_WIDE, InstructionType.THREEREGS_WIDE, InstructionType.THREEREGS_WIDE, InstructionType.TWOREGSPACKED_SINGLE, InstructionType.TWOREGSPACKED_SINGLE, InstructionType.TWOREGSPACKED_SINGLE, InstructionType.TWOREGSPACKED_SINGLE, InstructionType.TWOREGSPACKED_SINGLE, InstructionType.TWOREGSPACKED_SINGLE, InstructionType.TWOREGSPACKED_SINGLE, InstructionType.TWOREGSPACKED_SINGLE, InstructionType.TWOREGSPACKED_SINGLE, InstructionType.TWOREGSPACKED_SINGLE, InstructionType.TWOREGSPACKED_SINGLE, InstructionType.TWOREGSPACKED_DOUBLE, InstructionType.TWOREGSPACKED_DOUBLE, InstructionType.TWOREGSPACKED_DOUBLE, InstructionType.TWOREGSPACKED_DOUBLE, InstructionType.TWOREGSPACKED_DOUBLE, InstructionType.TWOREGSPACKED_DOUBLE, InstructionType.TWOREGSPACKED_DOUBLE, InstructionType.TWOREGSPACKED_DOUBLE, InstructionType.TWOREGSPACKED_DOUBLE, InstructionType.TWOREGSPACKED_DOUBLE, InstructionType.TWOREGSPACKED_DOUBLE, InstructionType.TWOREGSPACKED_SINGLE, InstructionType.TWOREGSPACKED_SINGLE, InstructionType.TWOREGSPACKED_SINGLE, InstructionType.TWOREGSPACKED_SINGLE, InstructionType.TWOREGSPACKED_SINGLE, InstructionType.TWOREGSPACKED_DOUBLE, InstructionType.TWOREGSPACKED_DOUBLE, InstructionType.TWOREGSPACKED_DOUBLE, InstructionType.TWOREGSPACKED_DOUBLE, InstructionType.TWOREGSPACKED_DOUBLE, InstructionType.TWOREGSPACKEDCONST16, InstructionType.TWOREGSPACKEDCONST16, InstructionType.TWOREGSPACKEDCONST16, InstructionType.TWOREGSPACKEDCONST16, InstructionType.TWOREGSPACKEDCONST16, InstructionType.TWOREGSPACKEDCONST16, InstructionType.TWOREGSPACKEDCONST16, InstructionType.TWOREGSPACKEDCONST16, InstructionType.TWOREGSCONST8, InstructionType.TWOREGSCONST8, InstructionType.TWOREGSCONST8, InstructionType.TWOREGSCONST8, InstructionType.TWOREGSCONST8, InstructionType.TWOREGSCONST8, InstructionType.TWOREGSCONST8, InstructionType.TWOREGSCONST8, InstructionType.TWOREGSCONST8, InstructionType.TWOREGSCONST8, InstructionType.TWOREGSCONST8, InstructionType.TWOREGSFIELD_READ, InstructionType.TWOREGSFIELD_WRITE, InstructionType.ONEREGFIELD_READ, InstructionType.ONEREGFIELD_WRITE, InstructionType.TWOREGSFIELD_READ_OBJECT, InstructionType.TWOREGSFIELD_READ_WIDE, InstructionType.TWOREGSFIELD_WRITE, InstructionType.ONEREGFIELD_READ_WIDE, InstructionType.ONEREGFIELD_WRITE, InstructionType.UNKNOWN_INSTRUCTION, InstructionType.UNKNOWN_INSTRUCTION, InstructionType.INLINEMETHODINVOKE, InstructionType.INLINEMETHODINVOKE_RANGE, InstructionType.METHODINVOKE, InstructionType.NOPARAMETER, InstructionType.TWOREGSQUICKOFFSET, InstructionType.TWOREGSQUICKOFFSET_WIDE, InstructionType.TWOREGSQUICKOFFSET_OBJECT, InstructionType.TWOREGSQUICKOFFSET_WRITE, InstructionType.TWOREGSQUICKOFFSET_WRITE, InstructionType.TWOREGSQUICKOFFSET_WRITE, InstructionType.QUICKMETHODINVOKE, InstructionType.QUICKMETHODINVOKE_RANGE, InstructionType.QUICKMETHODINVOKE, InstructionType.QUICKMETHODINVOKE_RANGE, InstructionType.TWOREGSFIELD_WRITE, InstructionType.ONEREGFIELD_READ_OBJECT, InstructionType.ONEREGFIELD_WRITE, InstructionType.UNKNOWN_INSTRUCTION};
    String[] instructionNames = new String[]{"nop", "move", "move/from16", "move/16", "move-wide", "move-wide/from16", "move-wide/16", "move-object", "move-object/from16", "move-object/16", "move-result", "move-result-wide", "move-result-object", "move-exception", "return-void", "return", "return-wide", "return-object", "const/4", "const/16", "const", "const/high16", "const-wide/16", "const-wide/32", "const-wide", "const-wide/high16", "const-string", "const-string/jumbo", "const-class", "monitor-enter", "monitor-exit", "check-cast", "instance-of", "array-length", "new-instance", "new-array", "filled-new-array", "filled-new-array/range", "fill-array-data", "throw", "goto", "goto/16", "", "packed-switch", "sparse-switch", "cmpl-float", "cmpg-float", "cmpl-double", "cmpg-double", "cmp-long", "if-eq", "if-ne", "if-lt", "if-ge", "if-gt", "if-le", "if-eqz", "if-nez", "if-ltz", "if-gez", "if-gtz", "if-lez", "", "", "", "", "", "", "aget", "aget-wide", "aget-object", "aget-boolean", "aget-byte", "aget-char", "aget-short", "aput", "aput-wide", "aput-object", "aput-boolean", "aput-byte", "aput-char", "aput-short", "iget", "iget-wide", "iget-object", "iget-boolean", "iget-byte", "iget-char", "iget-short", "iput", "iput-wide", "iput-object", "iput-boolean", "iput-byte", "iput-char", "iput-short", "sget", "sget-wide", "sget-object", "sget-boolean", "sget-byte", "sget-char", "sget-short", "sput", "sput-wide", "sput-object", "sput-boolean", "sput-byte", "sput-char", "sput-short", "invoke-virtual", "invoke-super", "invoke-direct", "invoke-static", "invoke-interface", "", "invoke-virtual/range", "invoke-super/range", "invoke-direct/range", "invoke-static/range", "invoke-interface/range", "", "", "neg-int", "", "neg-long", "", "neg-float", "neg-double", "int-to-long", "int-to-float", "int-to-double", "long-to-int", "long-to-float", "long-to-double", "float-to-int", "float-to-long", "float-to-double", "double-to-int", "double-to-long", "double-to-float", "int-to-byte", "int-to-char", "int-to-short", "add-int", "sub-int", "mul-int", "div-int", "rem-int", "and-int", "or-int", "xor-int", "shl-int", "shr-int", "ushr-int", "add-long", "sub-long", "mul-long", "div-long", "rem-long", "and-long", "or-long", "xor-long", "shl-long", "shr-long", "ushr-long", "add-float", "sub-float", "mul-float", "div-float", "rem-float", "add-double", "sub-double", "mul-double", "div-double", "rem-double", "add-int/2addr", "sub-int/2addr", "mul-int/2addr", "div-int/2addr", "rem-int/2addr", "and-int/2addr", "or-int/2addr", "xor-int/2addr", "shl-int/2addr", "shr-int/2addr", "ushr-int/2addr", "add-long/2addr", "sub-long/2addr", "mul-long/2addr", "div-long/2addr", "rem-long/2addr", "and-long/2addr", "or-long/2addr", "xor-long/2addr", "shl-long/2addr", "shr-long/2addr", "ushr-long/2addr", "add-float/2addr", "sub-float/2addr", "mul-float/2addr", "div-float/2addr", "rem-float/2addr", "add-double/2addr", "sub-double/2addr", "mul-double/2addr", "div-double/2addr", "rem-double/2addr", "add-int/lit16", "rsub-int", "mul-int/lit16", "div-int/lit16", "rem-int/lit16", "and-int/lit16", "or-int/lit16", "xor-int/lit16", "add-int/lit8", "rsub-int/lit8", "mul-int/lit8", "div-int/lit8", "rem-int/lit8", "and-int/lit8", "or-int/lit8", "xor-int/lit8", "shl-int/lit8", "shr-int/lit8", "ushr-int/lit8", "iget-volatile", "iput-volatile", "sget-volatile", "sput-volatile", "iget-object-volatile", "iget-wide-volatile", "iput-wide-volatile", "sget-wide-volatile", "sput-wide-volatile", "", "", "execute-inline", "execute-inline/range", "invoke-direct-empty", "return-void-barrier", "iget-quick", "iget-wide-quick", "iget-object-quick", "iput-quick", "iput-wide-quick", "iput-object-quick", "invoke-virtual-quick", "invoke-virtual-quick/range", "invoke-super-quick", "invoke-super-quick/range", "iput-object-volatile", "sget-object-volatile", "sput-object-volatile", ""};
    int[] terminateInstructions = new int[]{14, 15, 16, 17, 39, 241};
    private int[] affectedRegisters;
    private HashMap<Integer, String> regMap = new HashMap();
    private HashMap<Long, DedexerTask> labels = new HashMap();
    private ArrayList<DedexerTask> tasks = new ArrayList();
    private boolean secondPass = false;
    private CodeGenerator codeGenerator;
    private long lowestDataBlock = -1L;
    private ForkStatus forkStatus;
    private long[] forkData = null;
    private HashMap<Long, String> quickParameterMap = new HashMap();
    private static final boolean DEBUG_GETAFFECTEDREGSFORREGLIST = false;
    private ArrayList<RegisterTraces> regTraces = null;

    public void initializePass(boolean secondPass) {
        this.secondPass = secondPass;
        this.tasks.clear();
    }

    @Override
    public void parse() throws IOException, UnknownInstructionException {
        long instrBase = this.file.getFilePointer();
        int instrCode = this.read8Bit();
        InstructionType instrType = this.instructionTypes[instrCode];
        StringBuilder instrText = new StringBuilder();
        instrText.append(this.instructionNames[instrCode]);
        instrText.append("\t");
        this.forkStatus = this.initialForkStatus(instrCode);
        this.forkData = null;
        this.affectedRegisters = null;
        boolean generateText = true;
        switch (instrType) {
            case UNKNOWN_INSTRUCTION: {
                throw new UnknownInstructionException("Unknown instruction 0x" + this.dumpByte(instrCode) + " at offset " + this.dumpLong(this.file.getFilePointer() - 1L));
            }
            case REGCONST4: {
                int b1 = this.read8Bit();
                int reg = b1 & 0xF;
                int constant = (b1 & 0xF0) >> 4;
                instrText.append("v" + reg);
                instrText.append(",");
                instrText.append(constant);
                this.affectedRegisters = new int[1];
                this.affectedRegisters[0] = reg;
                this.regMap.put(new Integer(reg), TYPE_SINGLE_LENGTH);
                break;
            }
            case REGSTRINGCONST: {
                int reg = this.read8Bit();
                int stringidx = this.read16Bit();
                instrText.append("v" + reg);
                instrText.append(",");
                instrText.append("\"" + DexStringIdsBlock.escapeString(this.dexStringIdsBlock.getString(stringidx)) + "\"");
                this.affectedRegisters = new int[1];
                this.affectedRegisters[0] = reg;
                this.regMap.put(new Integer(reg), "Ljava/lang/String;");
                break;
            }
            case REGSTRINGCONST_JUMBO: {
                int reg = this.read8Bit();
                int stringidx = (int)this.read32Bit();
                instrText.append("v" + reg);
                instrText.append(",");
                instrText.append("\"" + DexStringIdsBlock.escapeString(this.dexStringIdsBlock.getString(stringidx)) + "\"");
                this.affectedRegisters = new int[1];
                this.affectedRegisters[0] = reg;
                this.regMap.put(new Integer(reg), "Ljava/lang/String;");
                break;
            }
            case METHODINVOKE: {
                int methodidx;
                String proto;
                String resultType;
                int regno;
                int b2 = this.read8Bit();
                int origRegNo = regno = (b2 & 0xF0) >> 4;
                int lastreg = -1;
                if (regno > 4 && regno % 4 == 1) {
                    --regno;
                    lastreg = b2 & 0xF;
                }
                if ("V".equals(resultType = DexMethodIdsBlock.getResultType(proto = this.dexMethodIdsBlock.getProto(methodidx = this.read16Bit())))) {
                    this.regMap.remove(REGMAP_RESULT_KEY);
                } else {
                    this.regMap.put(REGMAP_RESULT_KEY, DexInstructionParser.convertJavaTypeToInternal(resultType));
                }
                instrText.append("{");
                int regByte = 0;
                int byteCounter = 0;
                ArrayList<Integer> registerList = new ArrayList<Integer>();
                for (int i = 0; i < regno; ++i) {
                    if (i > 0) {
                        instrText.append(",");
                    }
                    int reg = 0;
                    if (i % 2 == 0) {
                        regByte = this.read8Bit();
                        ++byteCounter;
                        reg = regByte & 0xF;
                    } else {
                        reg = (regByte & 0xF0) >> 4;
                    }
                    instrText.append("v" + reg);
                    registerList.add(new Integer(reg));
                }
                if (lastreg >= 0) {
                    instrText.append(",v" + lastreg);
                    registerList.add(new Integer(lastreg));
                }
                if (byteCounter % 2 != 0) {
                    this.read8Bit();
                }
                instrText.append("},");
                instrText.append(this.dexMethodIdsBlock.getMethod(methodidx));
                instrText.append("\t; " + proto);
                this.affectedRegisters = this.getAffectedRegistersForRegList(registerList, proto, 1);
                break;
            }
            case METHODINVOKE_STATIC: {
                int methodidx;
                String proto;
                String resultType;
                int regno;
                int b2 = this.read8Bit();
                int origRegNo = regno = (b2 & 0xF0) >> 4;
                int lastreg = -1;
                if (regno > 4 && regno % 4 == 1) {
                    --regno;
                    lastreg = b2 & 0xF;
                }
                if ("V".equals(resultType = DexMethodIdsBlock.getResultType(proto = this.dexMethodIdsBlock.getProto(methodidx = this.read16Bit())))) {
                    this.regMap.remove(REGMAP_RESULT_KEY);
                } else {
                    this.regMap.put(REGMAP_RESULT_KEY, DexInstructionParser.convertJavaTypeToInternal(resultType));
                }
                instrText.append("{");
                int regByte = 0;
                int byteCounter = 0;
                ArrayList<Integer> registerList = new ArrayList<Integer>();
                for (int i = 0; i < regno; ++i) {
                    if (i > 0) {
                        instrText.append(",");
                    }
                    int reg = 0;
                    if (i % 2 == 0) {
                        regByte = this.read8Bit();
                        ++byteCounter;
                        reg = regByte & 0xF;
                    } else {
                        reg = (regByte & 0xF0) >> 4;
                    }
                    instrText.append("v" + reg);
                    registerList.add(new Integer(reg));
                }
                if (lastreg >= 0) {
                    instrText.append(",v" + lastreg);
                    registerList.add(new Integer(lastreg));
                }
                if (byteCounter % 2 != 0) {
                    this.read8Bit();
                }
                instrText.append("},");
                instrText.append(this.dexMethodIdsBlock.getMethod(methodidx));
                instrText.append("\t; " + proto);
                this.affectedRegisters = this.getAffectedRegistersForRegList(registerList, proto, 0);
                break;
            }
            case QUICKMETHODINVOKE: {
                int regno;
                int b2 = this.read8Bit();
                int origRegNo = regno = (b2 & 0xF0) >> 4;
                int lastreg = -1;
                if (regno > 4 && regno % 4 == 1) {
                    --regno;
                    lastreg = b2 & 0xF;
                }
                int vtableOffset = this.read16Bit();
                instrText.append("{");
                int regByte = 0;
                int byteCounter = 0;
                String baseClass = null;
                ArrayList<Integer> registerList = new ArrayList<Integer>();
                for (int i = 0; i < regno; ++i) {
                    if (i > 0) {
                        instrText.append(",");
                    }
                    int reg = 0;
                    if (i % 2 == 0) {
                        regByte = this.read8Bit();
                        ++byteCounter;
                        reg = regByte & 0xF;
                    } else {
                        reg = (regByte & 0xF0) >> 4;
                    }
                    instrText.append("v" + reg);
                    registerList.add(new Integer(reg));
                    if (this.secondPass || this.dexOffsetResolver == null || i != 0) continue;
                    baseClass = this.regMap.get(new Integer(reg));
                    if (baseClass == null || TYPE_SINGLE_LENGTH.equals(baseClass) || TYPE_DOUBLE_LENGTH.equals(baseClass)) {
                        baseClass = this.getLocalVariableType(instrBase, reg);
                    }
                    if (baseClass == null) continue;
                    baseClass = DexTypeIdsBlock.LTypeToJava(baseClass);
                }
                if (lastreg >= 0) {
                    instrText.append("v" + lastreg);
                    registerList.add(new Integer(lastreg));
                }
                if (byteCounter % 2 != 0) {
                    this.read8Bit();
                }
                instrText.append("},");
                boolean offsetResolved = false;
                if (this.dexOffsetResolver != null) {
                    String methodProto;
                    if (this.secondPass) {
                        Long key = new Long(this.file.getFilePointer());
                        String parameter = this.quickParameterMap.get(key);
                        if (parameter != null) {
                            instrText.append(parameter);
                            offsetResolved = true;
                        }
                    } else if (baseClass != null && (methodProto = this.dexOffsetResolver.getMethodNameFromOffset(baseClass, vtableOffset)) != null) {
                        String proto = "";
                        int idx = methodProto.indexOf(44);
                        if (idx >= 0) {
                            proto = methodProto.substring(idx + 1);
                            methodProto = methodProto.substring(0, idx);
                        }
                        String parameter = methodProto + "\t; " + proto + " , vtable #0x" + Integer.toHexString(vtableOffset);
                        Long key = new Long(this.file.getFilePointer());
                        this.quickParameterMap.put(key, parameter);
                        instrText.append(parameter);
                        String resultType = DexMethodIdsBlock.getResultType(proto);
                        if ("V".equals(resultType)) {
                            this.regMap.remove(REGMAP_RESULT_KEY);
                        } else {
                            this.regMap.put(REGMAP_RESULT_KEY, DexInstructionParser.convertJavaTypeToInternal(resultType));
                        }
                        this.affectedRegisters = this.getAffectedRegistersForRegList(registerList, proto, 1);
                        offsetResolved = true;
                    }
                }
                if (offsetResolved) break;
                instrText.append("vtable #0x" + Integer.toHexString(vtableOffset));
                this.affectedRegisters = new int[registerList.size()];
                for (int i = 0; i < registerList.size(); ++i) {
                    this.affectedRegisters[i] = (Integer)registerList.get(i);
                }
                break;
            }
            case INLINEMETHODINVOKE: {
                int regno;
                int b2 = this.read8Bit();
                int origRegNo = regno = (b2 & 0xF0) >> 4;
                int lastreg = -1;
                ArrayList<Integer> registerList = new ArrayList<Integer>();
                if (regno > 4 && regno % 4 == 1) {
                    --regno;
                    lastreg = b2 & 0xF;
                }
                int inlineOffset = this.read16Bit();
                instrText.append("{");
                int regByte = 0;
                int byteCounter = 0;
                for (int i = 0; i < regno; ++i) {
                    if (i > 0) {
                        instrText.append(",");
                    }
                    int reg = 0;
                    if (i % 2 == 0) {
                        regByte = this.read8Bit();
                        ++byteCounter;
                        reg = regByte & 0xF;
                    } else {
                        reg = (regByte & 0xF0) >> 4;
                    }
                    instrText.append("v" + reg);
                    registerList.add(new Integer(reg));
                }
                if (lastreg >= 0) {
                    instrText.append("v" + lastreg);
                    registerList.add(new Integer(lastreg));
                }
                if (byteCounter % 2 != 0) {
                    this.read8Bit();
                }
                instrText.append("},");
                boolean offsetResolved = false;
                if (this.secondPass) {
                    Long key = new Long(this.file.getFilePointer());
                    String parameter = this.quickParameterMap.get(key);
                    if (parameter != null) {
                        instrText.append(parameter);
                        offsetResolved = true;
                    }
                } else {
                    String methodProto = DexOffsetResolver.getInlineMethodNameFromIndex(inlineOffset, this.dexSignatureBlock.getOptVersion());
                    if (methodProto != null) {
                        String proto = "";
                        int idx = methodProto.indexOf(44);
                        if (idx >= 0) {
                            proto = methodProto.substring(idx + 1);
                            methodProto = methodProto.substring(0, idx);
                        }
                        String parameter = methodProto + "\t; " + proto + " , inline #0x" + Integer.toHexString(inlineOffset);
                        Long key = new Long(this.file.getFilePointer());
                        this.quickParameterMap.put(key, parameter);
                        instrText.append(parameter);
                        String resultType = DexMethodIdsBlock.getResultType(proto);
                        if ("V".equals(resultType)) {
                            this.regMap.remove(REGMAP_RESULT_KEY);
                        } else {
                            this.regMap.put(REGMAP_RESULT_KEY, DexInstructionParser.convertJavaTypeToInternal(resultType));
                        }
                        this.affectedRegisters = this.getAffectedRegistersForRegList(registerList, proto, 1);
                        offsetResolved = true;
                    }
                }
                if (offsetResolved) break;
                instrText.append("inline #0x" + Integer.toHexString(inlineOffset));
                break;
            }
            case FILLEDARRAY: {
                int b2 = this.read8Bit();
                int regno = (b2 & 0xF0) >> 4;
                int lastreg = -1;
                if (regno > 4 && regno % 4 == 1) {
                    --regno;
                    lastreg = b2 & 0xF;
                }
                int typeidx = this.read16Bit();
                instrText.append("{");
                int regByte = 0;
                int byteCounter = 0;
                this.affectedRegisters = new int[regno];
                for (int i = 0; i < regno; ++i) {
                    if (i > 0) {
                        instrText.append(",");
                    }
                    int reg = 0;
                    if (i % 2 == 0) {
                        regByte = this.read8Bit();
                        ++byteCounter;
                        reg = regByte & 0xF;
                    } else {
                        reg = (regByte & 0xF0) >> 4;
                    }
                    instrText.append("v" + reg);
                    this.affectedRegisters[i] = reg;
                }
                if (lastreg >= 0) {
                    instrText.append("v" + lastreg);
                    this.affectedRegisters[regno - 1] = lastreg;
                }
                if (byteCounter % 2 != 0) {
                    this.read8Bit();
                }
                instrText.append("},");
                String arrayType = this.dexTypeIdsBlock.getType(typeidx);
                instrText.append(arrayType);
                this.regMap.put(REGMAP_RESULT_KEY, DexInstructionParser.convertJavaTypeToInternal(arrayType));
                break;
            }
            case METHODINVOKE_RANGE: {
                int regno = this.read8Bit();
                int methodidx = this.read16Bit();
                int rangestart = this.read16Bit();
                int rangeend = rangestart + regno - 1;
                String proto = this.dexMethodIdsBlock.getProto(methodidx);
                String resultType = DexMethodIdsBlock.getResultType(proto);
                if ("V".equals(resultType)) {
                    this.regMap.remove(REGMAP_RESULT_KEY);
                } else {
                    this.regMap.put(REGMAP_RESULT_KEY, DexInstructionParser.convertJavaTypeToInternal(resultType));
                }
                if (regno == 1) {
                    instrText.append("{v" + rangestart + "}");
                } else {
                    instrText.append("{v" + rangestart + "..v" + rangeend + "}");
                }
                instrText.append("," + this.dexMethodIdsBlock.getMethod(methodidx) + ";\t" + proto);
                this.affectedRegisters = this.getAffectedRegistersForRange(proto, rangestart, 1);
                break;
            }
            case METHODINVOKE_RANGE_STATIC: {
                int regno = this.read8Bit();
                int methodidx = this.read16Bit();
                int rangestart = this.read16Bit();
                int rangeend = rangestart + regno - 1;
                String proto = this.dexMethodIdsBlock.getProto(methodidx);
                String resultType = DexMethodIdsBlock.getResultType(proto);
                if ("V".equals(resultType)) {
                    this.regMap.remove(REGMAP_RESULT_KEY);
                } else {
                    this.regMap.put(REGMAP_RESULT_KEY, DexInstructionParser.convertJavaTypeToInternal(resultType));
                }
                if (regno == 1) {
                    instrText.append("{v" + rangestart + "}");
                } else {
                    instrText.append("{v" + rangestart + "..v" + rangeend + "}");
                }
                instrText.append("," + this.dexMethodIdsBlock.getMethod(methodidx) + ";\t" + proto);
                this.affectedRegisters = this.getAffectedRegistersForRange(proto, rangestart, 0);
                break;
            }
            case QUICKMETHODINVOKE_RANGE: {
                int regno = this.read8Bit();
                int vtableOffset = this.read16Bit();
                int rangestart = this.read16Bit();
                int rangeend = rangestart + regno - 1;
                if (regno == 1) {
                    instrText.append("{v" + rangestart + "}");
                } else {
                    instrText.append("{v" + rangestart + "..v" + rangeend + "}");
                }
                boolean offsetResolved = false;
                if (this.dexOffsetResolver != null) {
                    if (this.secondPass) {
                        Long key = new Long(this.file.getFilePointer());
                        String parameter = this.quickParameterMap.get(key);
                        if (parameter != null) {
                            instrText.append(parameter);
                            offsetResolved = true;
                        }
                    } else {
                        String baseClass = null;
                        if (this.dexOffsetResolver != null && (baseClass = this.regMap.get(new Integer(rangestart))) != null) {
                            String methodProto = this.dexOffsetResolver.getMethodNameFromOffset(baseClass = DexTypeIdsBlock.LTypeToJava(baseClass), vtableOffset);
                            if (methodProto != null) {
                                String proto = "";
                                int idx = methodProto.indexOf(44);
                                if (idx >= 0) {
                                    proto = methodProto.substring(idx + 1);
                                    methodProto = methodProto.substring(0, idx);
                                }
                                String parameter = baseClass + "/" + methodProto + "\t; " + proto + " , vtable #0x" + Integer.toHexString(vtableOffset);
                                instrText.append(parameter);
                                Long key = new Long(this.file.getFilePointer());
                                this.quickParameterMap.put(key, parameter);
                                String resultType = DexMethodIdsBlock.getResultType(proto);
                                if ("V".equals(resultType)) {
                                    this.regMap.remove(REGMAP_RESULT_KEY);
                                } else {
                                    this.regMap.put(REGMAP_RESULT_KEY, DexInstructionParser.convertJavaTypeToInternal(resultType));
                                }
                                this.affectedRegisters = this.getAffectedRegistersForRange(proto, rangestart, 1);
                                offsetResolved = true;
                            } else {
                                this.affectedRegisters = new int[regno];
                                for (int i = 0; i < regno; ++i) {
                                    this.affectedRegisters[i] = rangestart + i;
                                }
                            }
                        }
                    }
                }
                if (offsetResolved) break;
                instrText.append(",vtable #0x" + Integer.toHexString(vtableOffset));
                break;
            }
            case INLINEMETHODINVOKE_RANGE: {
                int regno = this.read8Bit();
                int inlineOffset = this.read16Bit();
                int rangestart = this.read16Bit();
                int rangeend = rangestart + regno - 1;
                if (regno == 1) {
                    instrText.append("{v" + rangestart + "},");
                } else {
                    instrText.append("{v" + rangestart + "..v" + rangeend + "},");
                }
                boolean offsetResolved = false;
                if (this.secondPass) {
                    Long key = new Long(this.file.getFilePointer());
                    String parameter = this.quickParameterMap.get(key);
                    if (parameter != null) {
                        instrText.append(parameter);
                        offsetResolved = true;
                    }
                } else {
                    String methodProto = DexOffsetResolver.getInlineMethodNameFromIndex(inlineOffset, this.dexSignatureBlock.getOptVersion());
                    if (methodProto != null) {
                        String proto = "";
                        int idx = methodProto.indexOf(44);
                        if (idx >= 0) {
                            proto = methodProto.substring(idx + 1);
                            methodProto = methodProto.substring(0, idx);
                        }
                        String parameter = methodProto + "\t; " + proto + " , inline #0x" + Integer.toHexString(inlineOffset);
                        Long key = new Long(this.file.getFilePointer());
                        this.quickParameterMap.put(key, parameter);
                        instrText.append(parameter);
                        String resultType = DexMethodIdsBlock.getResultType(proto);
                        if ("V".equals(resultType)) {
                            this.regMap.remove(REGMAP_RESULT_KEY);
                        } else {
                            this.regMap.put(REGMAP_RESULT_KEY, DexInstructionParser.convertJavaTypeToInternal(resultType));
                        }
                        this.affectedRegisters = this.getAffectedRegistersForRange(proto, rangestart, 1);
                        offsetResolved = true;
                    }
                }
                if (offsetResolved) break;
                instrText.append("inline #0x" + Integer.toHexString(inlineOffset));
                break;
            }
            case FILLEDARRAY_RANGE: {
                int regno = this.read8Bit();
                int typeidx = this.read16Bit();
                int rangestart = this.read16Bit();
                int rangeend = rangestart + regno - 1;
                if (regno == 1) {
                    instrText.append("{v" + rangestart + "}");
                } else {
                    instrText.append("{v" + rangestart + "..v" + rangeend + "}");
                }
                this.affectedRegisters = new int[regno];
                for (int i = 0; i < regno; ++i) {
                    this.affectedRegisters[i] = rangestart + i;
                }
                String arrayType = this.dexTypeIdsBlock.getType(typeidx);
                instrText.append("," + arrayType);
                this.regMap.put(REGMAP_RESULT_KEY, DexInstructionParser.convertJavaTypeToInternal(arrayType));
                break;
            }
            case NEWARRAY: {
                int regs = this.read8Bit();
                int typeidx = this.read16Bit();
                int targetreg = regs & 0xF;
                int sizereg = (regs & 0xF0) >> 4;
                String arrayType = this.dexTypeIdsBlock.getType(typeidx);
                this.regMap.put(new Integer(targetreg), arrayType);
                this.affectedRegisters = new int[2];
                this.affectedRegisters[0] = targetreg;
                this.affectedRegisters[1] = sizereg;
                instrText.append("v" + targetreg + ",v" + sizereg + "," + arrayType);
                break;
            }
            case FILLARRAYDATA: {
                int reg = this.read8Bit();
                int offset = this.readSigned32Bit();
                long target = instrBase + (long)offset * 2L;
                instrText.append("v" + reg + "," + "l" + Long.toHexString(target));
                this.affectedRegisters = new int[1];
                this.affectedRegisters[0] = reg;
                if (!this.secondPass) {
                    FillArrayTask fillArrayTask = new FillArrayTask(this, instrBase, target);
                    this.tasks.add(fillArrayTask);
                }
                this.updateLowestDataBlock(target);
                break;
            }
            case ONEREGFIELD_READ: {
                int reg = this.read8Bit();
                int fieldidx = this.read16Bit();
                instrText.append("v" + reg + "," + this.dexFieldIdsBlock.getField(fieldidx));
                this.affectedRegisters = new int[1];
                this.affectedRegisters[0] = reg;
                this.regMap.put(new Integer(reg), TYPE_SINGLE_LENGTH);
                break;
            }
            case ONEREGFIELD_READ_WIDE: {
                int reg = this.read8Bit();
                int fieldidx = this.read16Bit();
                instrText.append("v" + reg + "," + this.dexFieldIdsBlock.getField(fieldidx));
                this.affectedRegisters = new int[1];
                this.affectedRegisters[0] = reg;
                this.regMap.put(new Integer(reg), TYPE_DOUBLE_LENGTH);
                break;
            }
            case ONEREGFIELD_READ_OBJECT: {
                int reg = this.read8Bit();
                int fieldidx = this.read16Bit();
                instrText.append("v" + reg + "," + this.dexFieldIdsBlock.getField(fieldidx));
                this.affectedRegisters = new int[1];
                this.affectedRegisters[0] = reg;
                this.regMap.put(new Integer(reg), this.dexFieldIdsBlock.getFieldType(fieldidx));
                break;
            }
            case ONEREGFIELD_WRITE: {
                int reg = this.read8Bit();
                int fieldidx = this.read16Bit();
                instrText.append("v" + reg + "," + this.dexFieldIdsBlock.getField(fieldidx));
                this.affectedRegisters = new int[1];
                this.affectedRegisters[0] = reg;
                this.regMap.put(new Integer(reg), this.dexFieldIdsBlock.getFieldType(fieldidx));
                break;
            }
            case TWOREGSFIELD_READ: {
                int b1 = this.read8Bit();
                int reg1 = b1 & 0xF;
                int reg2 = (b1 & 0xF0) >> 4;
                int fieldidx = this.read16Bit();
                this.affectedRegisters = new int[2];
                this.affectedRegisters[0] = reg1;
                this.affectedRegisters[1] = reg2;
                instrText.append("v" + reg1 + ",v" + reg2 + "," + this.dexFieldIdsBlock.getField(fieldidx));
                this.regMap.put(new Integer(reg1), TYPE_SINGLE_LENGTH);
                break;
            }
            case TWOREGSFIELD_READ_WIDE: {
                int b1 = this.read8Bit();
                int reg1 = b1 & 0xF;
                int reg2 = (b1 & 0xF0) >> 4;
                int fieldidx = this.read16Bit();
                this.affectedRegisters = new int[2];
                this.affectedRegisters[0] = reg1;
                this.affectedRegisters[1] = reg2;
                instrText.append("v" + reg1 + ",v" + reg2 + "," + this.dexFieldIdsBlock.getField(fieldidx));
                this.regMap.put(new Integer(reg1), TYPE_DOUBLE_LENGTH);
                break;
            }
            case TWOREGSFIELD_READ_OBJECT: {
                int b1 = this.read8Bit();
                int reg1 = b1 & 0xF;
                int reg2 = (b1 & 0xF0) >> 4;
                int fieldidx = this.read16Bit();
                this.affectedRegisters = new int[2];
                this.affectedRegisters[0] = reg1;
                this.affectedRegisters[1] = reg2;
                instrText.append("v" + reg1 + ",v" + reg2 + "," + this.dexFieldIdsBlock.getField(fieldidx));
                this.regMap.put(new Integer(reg1), this.dexFieldIdsBlock.getFieldType(fieldidx));
                break;
            }
            case TWOREGSFIELD_WRITE: {
                int b1 = this.read8Bit();
                int reg1 = b1 & 0xF;
                int reg2 = (b1 & 0xF0) >> 4;
                int fieldidx = this.read16Bit();
                this.affectedRegisters = new int[2];
                this.affectedRegisters[0] = reg1;
                this.affectedRegisters[1] = reg2;
                instrText.append("v" + reg1 + ",v" + reg2 + "," + this.dexFieldIdsBlock.getField(fieldidx));
                break;
            }
            case NOPARAMETER: {
                int b = this.read8Bit();
                break;
            }
            case REGCONST16: {
                int targetreg = this.read8Bit();
                int constant = this.read16Bit();
                this.affectedRegisters = new int[1];
                this.affectedRegisters[0] = targetreg;
                instrText.append("v" + targetreg + "," + Integer.toString(constant));
                this.regMap.put(new Integer(targetreg), TYPE_SINGLE_LENGTH);
                break;
            }
            case REGCONST16_WIDE: {
                int targetreg = this.read8Bit();
                int constant = this.read16Bit();
                this.affectedRegisters = new int[1];
                this.affectedRegisters[0] = targetreg;
                instrText.append("v" + targetreg + "," + Integer.toString(constant));
                this.regMap.put(new Integer(targetreg), TYPE_DOUBLE_LENGTH);
                break;
            }
            case THREEREGS: {
                int reg1 = this.read8Bit();
                int reg2 = this.read8Bit();
                int reg3 = this.read8Bit();
                instrText.append("v" + reg1 + ",v" + reg2 + ",v" + reg3);
                this.affectedRegisters = new int[3];
                this.affectedRegisters[0] = reg1;
                this.affectedRegisters[1] = reg2;
                this.affectedRegisters[2] = reg3;
                this.regMap.put(new Integer(reg1), TYPE_SINGLE_LENGTH);
                break;
            }
            case THREEREGS_WIDE: {
                int reg1 = this.read8Bit();
                int reg2 = this.read8Bit();
                int reg3 = this.read8Bit();
                instrText.append("v" + reg1 + ",v" + reg2 + ",v" + reg3);
                this.affectedRegisters = new int[3];
                this.affectedRegisters[0] = reg1;
                this.affectedRegisters[1] = reg2;
                this.affectedRegisters[2] = reg3;
                this.regMap.put(new Integer(reg1), TYPE_DOUBLE_LENGTH);
                break;
            }
            case AGET: {
                int reg1 = this.read8Bit();
                int reg2 = this.read8Bit();
                int reg3 = this.read8Bit();
                instrText.append("v" + reg1 + ",v" + reg2 + ",v" + reg3);
                this.affectedRegisters = new int[3];
                this.affectedRegisters[0] = reg1;
                this.affectedRegisters[1] = reg2;
                this.affectedRegisters[2] = reg3;
                String arrayType = this.regMap.get(new Integer(reg2));
                String elementType = TYPE_UNKNOWN;
                if (arrayType != null && arrayType.startsWith("[")) {
                    elementType = DexInstructionParser.convertJavaTypeToInternal(arrayType.substring(1));
                }
                this.regMap.put(new Integer(reg1), elementType);
                break;
            }
            case APUT: {
                int reg1 = this.read8Bit();
                int reg2 = this.read8Bit();
                int reg3 = this.read8Bit();
                instrText.append("v" + reg1 + ",v" + reg2 + ",v" + reg3);
                this.affectedRegisters = new int[3];
                this.affectedRegisters[0] = reg1;
                this.affectedRegisters[1] = reg2;
                this.affectedRegisters[2] = reg3;
                break;
            }
            case PACKEDSWITCH: {
                int reg = this.read8Bit();
                int offset = this.readSigned32Bit();
                long target = instrBase + (long)offset * 2L;
                instrText.append("v" + reg);
                this.affectedRegisters = new int[1];
                this.affectedRegisters[0] = reg;
                generateText = false;
                if (!this.secondPass) {
                    PackedSwitchTask packedSwitchTask = new PackedSwitchTask(this, instrBase, target);
                    packedSwitchTask.setReg(reg);
                    this.tasks.add(packedSwitchTask);
                    this.forkData = packedSwitchTask.readJumpTable();
                    this.forkStatus = ForkStatus.FORK_AND_CONTINUE;
                }
                this.updateLowestDataBlock(target);
                break;
            }
            case SPARSESWITCH: {
                int reg = this.read8Bit();
                int offset = this.readSigned32Bit();
                long target = instrBase + (long)offset * 2L;
                instrText.append("v" + reg);
                this.affectedRegisters = new int[1];
                this.affectedRegisters[0] = reg;
                generateText = false;
                if (!this.secondPass) {
                    SparseSwitchTask sparseSwitchTask = new SparseSwitchTask(this, instrBase, target);
                    sparseSwitchTask.setReg(reg);
                    this.tasks.add(sparseSwitchTask);
                    this.forkData = sparseSwitchTask.readJumpTable();
                    this.forkStatus = ForkStatus.FORK_AND_CONTINUE;
                }
                this.updateLowestDataBlock(target);
                break;
            }
            case MOVERESULT: {
                int reg = this.read8Bit();
                instrText.append("v" + reg);
                this.affectedRegisters = new int[1];
                this.affectedRegisters[0] = reg;
                this.regMap.put(new Integer(reg), this.regMap.get(REGMAP_RESULT_KEY));
                break;
            }
            case ONEREG: {
                int reg = this.read8Bit();
                instrText.append("v" + reg);
                this.affectedRegisters = new int[1];
                this.affectedRegisters[0] = reg;
                break;
            }
            case OFFSET8: {
                long target = this.calculateTarget(instrBase);
                instrText.append(DexInstructionParser.labelForAddress(target));
                this.forkData = new long[1];
                this.forkData[0] = target;
                this.forkStatus = ForkStatus.FORK_UNCONDITIONALLY;
                break;
            }
            case CHECKCAST: {
                int reg = this.read8Bit();
                int typeidx = this.read16Bit();
                String castType = this.dexTypeIdsBlock.getClassName(typeidx);
                instrText.append("v" + reg + "," + castType);
                this.affectedRegisters = new int[1];
                this.affectedRegisters[0] = reg;
                if (!castType.startsWith("[")) {
                    castType = "L" + castType + ";";
                }
                this.regMap.put(new Integer(reg), castType);
                break;
            }
            case NEWINSTANCE: {
                int reg = this.read8Bit();
                int typeidx = this.read16Bit();
                String type = this.dexTypeIdsBlock.getClassName(typeidx);
                instrText.append("v" + reg + "," + type);
                this.affectedRegisters = new int[1];
                this.affectedRegisters[0] = reg;
                this.regMap.put(new Integer(reg), "L" + type + ";");
                break;
            }
            case TWOREGSTYPE: {
                int b1 = this.read8Bit();
                int reg1 = b1 & 0xF;
                int reg2 = (b1 & 0xF0) >> 4;
                int typeidx = this.read16Bit();
                instrText.append("v" + reg1 + ",v" + reg2 + "," + this.dexTypeIdsBlock.getClassName(typeidx));
                this.affectedRegisters = new int[2];
                this.affectedRegisters[0] = reg1;
                this.affectedRegisters[1] = reg2;
                this.regMap.put(new Integer(reg1), TYPE_SINGLE_LENGTH);
                break;
            }
            case REGOFFSET16: {
                int reg = this.read8Bit();
                long target = this.calculateTarget16Bit(instrBase);
                instrText.append("v" + reg + "," + DexInstructionParser.labelForAddress(target));
                this.forkData = new long[1];
                this.forkData[0] = target;
                this.forkStatus = ForkStatus.FORK_AND_CONTINUE;
                this.affectedRegisters = new int[1];
                this.affectedRegisters[0] = reg;
                break;
            }
            case OFFSET16: {
                int padding = this.read8Bit();
                long target = this.calculateTarget16Bit(instrBase);
                instrText.append(DexInstructionParser.labelForAddress(target));
                this.forkData = new long[1];
                this.forkData[0] = target;
                this.forkStatus = ForkStatus.FORK_UNCONDITIONALLY;
                break;
            }
            case TWOREGSOFFSET16: {
                int b1 = this.read8Bit();
                int reg1 = b1 & 0xF;
                int reg2 = (b1 & 0xF0) >> 4;
                long target = this.calculateTarget16Bit(instrBase);
                instrText.append("v" + reg1 + ",v" + reg2 + "," + DexInstructionParser.labelForAddress(target));
                this.affectedRegisters = new int[2];
                this.affectedRegisters[0] = reg1;
                this.affectedRegisters[1] = reg2;
                this.forkData = new long[1];
                this.forkData[0] = target;
                this.forkStatus = ForkStatus.FORK_AND_CONTINUE;
                break;
            }
            case MOVE: {
                int b1 = this.read8Bit();
                int reg1 = b1 & 0xF;
                int reg2 = (b1 & 0xF0) >> 4;
                instrText.append("v" + reg1 + ",v" + reg2);
                this.affectedRegisters = new int[2];
                this.affectedRegisters[0] = reg1;
                this.affectedRegisters[1] = reg2;
                this.regMap.put(new Integer(reg1), this.regMap.get(new Integer(reg2)));
                break;
            }
            case MOVE_OBJECT: {
                int b1 = this.read8Bit();
                int reg1 = b1 & 0xF;
                int reg2 = (b1 & 0xF0) >> 4;
                instrText.append("v" + reg1 + ",v" + reg2);
                this.affectedRegisters = new int[2];
                this.affectedRegisters[0] = reg1;
                this.affectedRegisters[1] = reg2;
                this.regMap.put(new Integer(reg1), this.getRegType(instrBase, reg2));
                break;
            }
            case TWOREGSPACKED_SINGLE: {
                int b1 = this.read8Bit();
                int reg1 = b1 & 0xF;
                int reg2 = (b1 & 0xF0) >> 4;
                instrText.append("v" + reg1 + ",v" + reg2);
                this.affectedRegisters = new int[2];
                this.affectedRegisters[0] = reg1;
                this.affectedRegisters[1] = reg2;
                this.regMap.put(new Integer(reg1), TYPE_SINGLE_LENGTH);
                break;
            }
            case TWOREGSPACKED_DOUBLE: {
                int b1 = this.read8Bit();
                int reg1 = b1 & 0xF;
                int reg2 = (b1 & 0xF0) >> 4;
                instrText.append("v" + reg1 + ",v" + reg2);
                this.affectedRegisters = new int[2];
                this.affectedRegisters[0] = reg1;
                this.affectedRegisters[1] = reg2;
                this.regMap.put(new Integer(reg1), TYPE_DOUBLE_LENGTH);
                break;
            }
            case TWOREGSCONST8: {
                int reg1 = this.read8Bit();
                int reg2 = this.read8Bit();
                int constant = this.read8Bit();
                this.affectedRegisters = new int[2];
                this.affectedRegisters[0] = reg1;
                this.affectedRegisters[1] = reg2;
                this.regMap.put(new Integer(reg1), TYPE_SINGLE_LENGTH);
                instrText.append("v" + reg1 + ",v" + reg2 + "," + constant);
                break;
            }
            case REGCLASSCONST: {
                int reg = this.read8Bit();
                int typeidx = this.read16Bit();
                String type = this.dexTypeIdsBlock.getClassName(typeidx);
                instrText.append("v" + reg + "," + type);
                this.affectedRegisters = new int[1];
                this.affectedRegisters[0] = reg;
                this.regMap.put(new Integer(reg), "Ljava/lang/Class;");
                break;
            }
            case REGCONST32: {
                int reg = this.read8Bit();
                long constant = this.read32Bit();
                instrText.append("v" + reg + "," + constant + "\t; 0x" + Long.toHexString(constant));
                this.affectedRegisters = new int[1];
                this.affectedRegisters[0] = reg;
                this.regMap.put(new Integer(reg), TYPE_SINGLE_LENGTH);
                break;
            }
            case REGCONST32_WIDE: {
                int reg = this.read8Bit();
                long constant = this.read32Bit();
                instrText.append("v" + reg + "," + constant + "\t; 0x" + Long.toHexString(constant));
                this.affectedRegisters = new int[1];
                this.affectedRegisters[0] = reg;
                this.regMap.put(new Integer(reg), TYPE_DOUBLE_LENGTH);
                break;
            }
            case REGCONST64: {
                int reg = this.read8Bit();
                long const1 = this.read32Bit();
                long const2 = this.read32Bit();
                long constant = const2 << 32 | const1;
                instrText.append("v" + reg + "," + constant + "\t; 0x" + Long.toHexString(constant));
                this.affectedRegisters = new int[1];
                this.affectedRegisters[0] = reg;
                this.regMap.put(new Integer(reg), TYPE_DOUBLE_LENGTH);
                break;
            }
            case REG8REG16: {
                int reg1 = this.read8Bit();
                int reg2 = this.read16Bit();
                instrText.append("v" + reg1 + ",v" + reg2);
                this.affectedRegisters = new int[2];
                this.affectedRegisters[0] = reg1;
                this.affectedRegisters[1] = reg2;
                this.regMap.put(new Integer(reg1), this.regMap.get(new Integer(reg2)));
                break;
            }
            case REG8REG16_OBJECT: {
                int reg1 = this.read8Bit();
                int reg2 = this.read16Bit();
                instrText.append("v" + reg1 + ",v" + reg2);
                this.affectedRegisters = new int[2];
                this.affectedRegisters[0] = reg1;
                this.affectedRegisters[1] = reg2;
                this.regMap.put(new Integer(reg1), this.getRegType(instrBase, reg2));
                break;
            }
            case REG16REG16: {
                int garbage = this.read8Bit();
                int reg1 = this.read16Bit();
                int reg2 = this.read16Bit();
                instrText.append("v" + reg1 + ",v" + reg2);
                this.affectedRegisters = new int[2];
                this.affectedRegisters[0] = reg1;
                this.affectedRegisters[1] = reg2;
                this.regMap.put(new Integer(reg1), this.regMap.get(new Integer(reg2)));
                break;
            }
            case REG16REG16_OBJECT: {
                int garbage = this.read8Bit();
                int reg1 = this.read16Bit();
                int reg2 = this.read16Bit();
                instrText.append("v" + reg1 + ",v" + reg2);
                this.affectedRegisters = new int[2];
                this.affectedRegisters[0] = reg1;
                this.affectedRegisters[1] = reg2;
                this.regMap.put(new Integer(reg1), this.getRegType(instrBase, reg2));
                break;
            }
            case TWOREGSPACKEDCONST16: {
                int reg = this.read8Bit();
                int reg1 = reg & 0xF;
                int reg2 = (reg & 0xF0) >> 4;
                int constant = this.read16Bit();
                instrText.append("v" + reg1 + ",v" + reg2 + "," + constant);
                this.affectedRegisters = new int[2];
                this.affectedRegisters[0] = reg1;
                this.affectedRegisters[1] = reg2;
                this.regMap.put(new Integer(reg1), TYPE_SINGLE_LENGTH);
                break;
            }
            case TWOREGSQUICKOFFSET: {
                String fieldName;
                int reg = this.read8Bit();
                int reg1 = reg & 0xF;
                int reg2 = (reg & 0xF0) >> 4;
                int constant = this.read16Bit();
                String baseClass = null;
                if (this.dexOffsetResolver != null) {
                    baseClass = this.regMap.get(new Integer(reg2));
                }
                if (baseClass != null) {
                    baseClass = DexTypeIdsBlock.LTypeToJava(baseClass);
                }
                instrText.append("v" + reg1 + ",v" + reg2 + ",");
                this.affectedRegisters = new int[2];
                this.affectedRegisters[0] = reg1;
                this.affectedRegisters[1] = reg2;
                this.regMap.put(new Integer(reg1), TYPE_SINGLE_LENGTH);
                boolean offsetResolved = false;
                if (this.secondPass) {
                    Long key = new Long(this.file.getFilePointer());
                    String parameter = this.quickParameterMap.get(key);
                    if (parameter != null) {
                        instrText.append(parameter);
                        offsetResolved = true;
                    }
                } else if (baseClass != null && (fieldName = this.dexOffsetResolver.getFieldNameFromOffset(baseClass, constant)) != null) {
                    Long key = new Long(this.file.getFilePointer());
                    fieldName = fieldName + "\t;[obj+0x" + Integer.toHexString(constant) + "]";
                    this.quickParameterMap.put(key, fieldName);
                    instrText.append(fieldName);
                    offsetResolved = true;
                }
                if (offsetResolved) break;
                instrText.append("[obj+0x" + Integer.toHexString(constant) + "]");
                break;
            }
            case TWOREGSQUICKOFFSET_WIDE: {
                String fieldName;
                int reg = this.read8Bit();
                int reg1 = reg & 0xF;
                int reg2 = (reg & 0xF0) >> 4;
                int constant = this.read16Bit();
                String baseClass = null;
                if (this.dexOffsetResolver != null) {
                    baseClass = this.regMap.get(new Integer(reg2));
                }
                if (baseClass != null) {
                    baseClass = DexTypeIdsBlock.LTypeToJava(baseClass);
                }
                instrText.append("v" + reg1 + ",v" + reg2 + ",");
                this.affectedRegisters = new int[2];
                this.affectedRegisters[0] = reg1;
                this.affectedRegisters[1] = reg2;
                this.regMap.put(new Integer(reg1), TYPE_DOUBLE_LENGTH);
                boolean offsetResolved = false;
                if (this.secondPass) {
                    Long key = new Long(this.file.getFilePointer());
                    String parameter = this.quickParameterMap.get(key);
                    if (parameter != null) {
                        instrText.append(parameter);
                        offsetResolved = true;
                    }
                } else if (baseClass != null && (fieldName = this.dexOffsetResolver.getFieldNameFromOffset(baseClass, constant)) != null) {
                    Long key = new Long(this.file.getFilePointer());
                    fieldName = fieldName + "\t;[obj+0x" + Integer.toHexString(constant) + "]";
                    this.quickParameterMap.put(key, fieldName);
                    instrText.append(fieldName);
                    offsetResolved = true;
                }
                if (offsetResolved) break;
                instrText.append("[obj+0x" + Integer.toHexString(constant) + "]");
                break;
            }
            case TWOREGSQUICKOFFSET_OBJECT: {
                String fieldName;
                int reg = this.read8Bit();
                int reg1 = reg & 0xF;
                int reg2 = (reg & 0xF0) >> 4;
                int constant = this.read16Bit();
                String baseClass = null;
                if (this.dexOffsetResolver != null) {
                    baseClass = this.regMap.get(new Integer(reg2));
                }
                if (baseClass != null) {
                    baseClass = DexTypeIdsBlock.LTypeToJava(baseClass);
                }
                instrText.append("v" + reg1 + ",v" + reg2 + ",");
                boolean offsetResolved = false;
                String resultType = "L<unknown>;";
                if (this.secondPass) {
                    Long key = new Long(this.file.getFilePointer());
                    String parameter = this.quickParameterMap.get(key);
                    if (parameter != null) {
                        instrText.append(parameter);
                        offsetResolved = true;
                    }
                } else if (baseClass != null && (fieldName = this.dexOffsetResolver.getFieldNameFromOffset(baseClass, constant)) != null) {
                    int idx = fieldName.indexOf(32);
                    if (idx >= 0) {
                        // empty if block
                    }
                    resultType = fieldName.substring(idx + 1);
                    fieldName = fieldName + "\t;[obj+0x" + Integer.toHexString(constant) + "]";
                    Long key = new Long(this.file.getFilePointer());
                    this.quickParameterMap.put(key, fieldName);
                    instrText.append(fieldName);
                    offsetResolved = true;
                }
                if (!offsetResolved) {
                    instrText.append("[obj+0x" + Integer.toHexString(constant) + "]");
                }
                this.affectedRegisters = new int[2];
                this.affectedRegisters[0] = reg1;
                this.affectedRegisters[1] = reg2;
                this.regMap.put(new Integer(reg1), resultType);
                break;
            }
            case TWOREGSQUICKOFFSET_WRITE: {
                String fieldName;
                int reg = this.read8Bit();
                int reg1 = reg & 0xF;
                int reg2 = (reg & 0xF0) >> 4;
                int constant = this.read16Bit();
                String baseClass = null;
                if (this.dexOffsetResolver != null) {
                    baseClass = this.regMap.get(new Integer(reg2));
                }
                if (baseClass != null) {
                    baseClass = DexTypeIdsBlock.LTypeToJava(baseClass);
                }
                instrText.append("v" + reg1 + ",v" + reg2 + ",");
                this.affectedRegisters = new int[2];
                this.affectedRegisters[0] = reg1;
                this.affectedRegisters[1] = reg2;
                boolean offsetResolved = false;
                if (this.secondPass) {
                    Long key = new Long(this.file.getFilePointer());
                    String parameter = this.quickParameterMap.get(key);
                    if (parameter != null) {
                        instrText.append(parameter);
                        offsetResolved = true;
                    }
                } else if (baseClass != null && (fieldName = this.dexOffsetResolver.getFieldNameFromOffset(baseClass, constant)) != null) {
                    Long key = new Long(this.file.getFilePointer());
                    fieldName = fieldName + "\t;[obj+0x" + Integer.toHexString(constant) + "]";
                    this.quickParameterMap.put(key, fieldName);
                    instrText.append(fieldName);
                    offsetResolved = true;
                }
                if (offsetResolved) break;
                instrText.append("[obj+0x" + Integer.toHexString(constant) + "]");
            }
        }
        if (generateText) {
            this.dump("\t" + instrText);
        }
    }

    public void setDexSignatureBlock(DexSignatureBlock dexSignatureBlock) {
        this.dexSignatureBlock = dexSignatureBlock;
    }

    public void setDexStringIdsBlock(DexStringIdsBlock dexStringIdsBlock) {
        this.dexStringIdsBlock = dexStringIdsBlock;
    }

    public void setDexTypeIdsBlock(DexTypeIdsBlock dexTypeIdsBlock) {
        this.dexTypeIdsBlock = dexTypeIdsBlock;
    }

    public void setDexFieldIdsBlock(DexFieldIdsBlock dexFieldIdsBlock) {
        this.dexFieldIdsBlock = dexFieldIdsBlock;
    }

    public void setDexOffsetResolver(DexOffsetResolver dexOffsetResolver) {
        this.dexOffsetResolver = dexOffsetResolver;
    }

    public void setDexMethodIdsBlock(DexMethodIdsBlock dexMethodIdsBlock) {
        this.dexMethodIdsBlock = dexMethodIdsBlock;
    }

    public void setPass(boolean secondPass) {
        this.secondPass = secondPass;
    }

    public void setRegTraces(ArrayList<RegisterTraces> regTraces) {
        this.regTraces = regTraces;
    }

    public DedexerTask getTaskForAddress(long address) {
        return this.labels.get(new Long(address));
    }

    public void postPassProcessing(boolean secondPass) throws IOException {
        for (int i = 0; i < this.tasks.size(); ++i) {
            DedexerTask task = this.tasks.get(i);
            try {
                task.doTask(secondPass);
                continue;
            }
            catch (Exception ex) {
                System.out.println("task error (secondPass=" + secondPass + ") " + ex.getMessage());
            }
        }
    }

    public void setCodeGenerator(CodeGenerator codeGenerator) {
        this.codeGenerator = codeGenerator;
    }

    public CodeGenerator getCodeGenerator() {
        return this.codeGenerator;
    }

    public long getLowestDataBlock() {
        return this.lowestDataBlock;
    }

    public static String labelForAddress(long address) {
        return "l" + Long.toHexString(address);
    }

    public void placeTask(long target, DedexerTask label) {
        Long key = new Long(target);
        DedexerTask existingTask = this.labels.get(key);
        if (existingTask == null) {
            this.labels.put(key, label);
        } else {
            if (!(existingTask instanceof TaskCollection)) {
                existingTask = new TaskCollection(this, existingTask);
                this.labels.put(key, existingTask);
            }
            TaskCollection taskCollection = (TaskCollection)existingTask;
            taskCollection.addTask(label);
        }
    }

    public void placeLabel(long target, String labelName) {
        if (this.secondPass) {
            return;
        }
        Long key = new Long(target);
        DedexerTask existingTask = this.labels.get(key);
        if (existingTask != null && existingTask.equals(labelName)) {
            return;
        }
        LabelTask labelTask = new LabelTask(this, labelName);
        this.placeTask(target, labelTask);
    }

    public ForkStatus getForkStatus() {
        return this.forkStatus;
    }

    public long[] getForkData() {
        return this.forkData;
    }

    public HashMap<Integer, String> getRegisterMap() {
        return this.regMap;
    }

    public void setRegisterMap(HashMap<Integer, String> regMap) {
        this.regMap = regMap;
    }

    public int[] getAffectedRegisters() {
        return this.affectedRegisters;
    }

    public static String convertJavaTypeToInternal(String javaType) {
        if (javaType.startsWith("L")) {
            return javaType;
        }
        if (javaType.startsWith("[")) {
            return javaType;
        }
        String internalType = "";
        switch (javaType.charAt(0)) {
            case 'D': 
            case 'J': {
                internalType = TYPE_DOUBLE_LENGTH;
                break;
            }
            default: {
                internalType = TYPE_SINGLE_LENGTH;
            }
        }
        return internalType;
    }

    private long calculateTarget(long instrBase) throws IOException {
        int offset = this.read8Bit();
        if ((offset & 0x80) != 0) {
            offset -= 256;
        }
        long target = instrBase + (long)(offset * 2);
        this.placeLabel(target, DexInstructionParser.labelForAddress(target));
        return target;
    }

    private long calculateTarget16Bit(long instrBase) throws IOException {
        int offset = this.read16Bit();
        if ((offset & 0x8000) != 0) {
            offset -= 65536;
        }
        long target = instrBase + (long)(offset * 2);
        this.placeLabel(target, DexInstructionParser.labelForAddress(target));
        return target;
    }

    private void updateLowestDataBlock(long address) {
        if (this.lowestDataBlock == -1L) {
            this.lowestDataBlock = address;
        } else if (address < this.lowestDataBlock) {
            this.lowestDataBlock = address;
        }
    }

    private ForkStatus initialForkStatus(int instrCode) {
        for (int i = 0; i < this.terminateInstructions.length; ++i) {
            if (this.terminateInstructions[i] != instrCode) continue;
            return ForkStatus.TERMINATE;
        }
        return ForkStatus.CONTINUE;
    }

    private int[] getAffectedRegistersForRange(String proto, int baseReg, int thisCount) {
        ArrayList regOffsets = DexClassDefsBlock.getMethodParameterOffsets(proto, 0);
        int affectedRegsSize = regOffsets.size() / 2 + thisCount;
        int[] affectedRegisters = new int[affectedRegsSize];
        if (thisCount > 0) {
            affectedRegisters[0] = baseReg;
        }
        int regOffset = -1;
        int regCount = thisCount;
        for (int i = 0; i < regOffsets.size(); i += 2) {
            int regx = (Integer)regOffsets.get(i);
            if (regOffset == -1) {
                regOffset = -regx + thisCount + baseReg;
            }
            affectedRegisters[regCount++] = regx + regOffset;
        }
        return affectedRegisters;
    }

    private int[] getAffectedRegistersForRegList(ArrayList<Integer> registerList, String proto, int notParmReg) {
        ArrayList<Boolean> widthList = DexClassDefsBlock.getMethodParameterWidth(proto);
        int[] affectedRegisters = new int[widthList.size() + notParmReg];
        for (int i = 0; i < notParmReg; ++i) {
            if (i >= registerList.size()) continue;
            affectedRegisters[i] = registerList.get(i);
        }
        int regCtr = notParmReg;
        for (int i = 0; i < widthList.size() && regCtr < registerList.size(); ++i) {
            affectedRegisters[i + notParmReg] = registerList.get(regCtr++);
            if (!widthList.get(i).booleanValue()) continue;
            ++regCtr;
        }
        return affectedRegisters;
    }

    private String getRegType(long pos, int regNo) {
        String newType;
        String type = this.regMap.get(new Integer(regNo));
        if ((type == null || TYPE_SINGLE_LENGTH.equals(type)) && (newType = this.getLocalVariableType(pos, regNo)) != null) {
            type = newType;
        }
        return type;
    }

    private String getLocalVariableType(long pos, int regNo) {
        if (this.regTraces == null) {
            return null;
        }
        for (int i = 0; i < this.regTraces.size(); ++i) {
            RegisterTraces regTrace = this.regTraces.get(i);
            if (!regTrace.isInTraceRange(pos) || regTrace.regNo != regNo) continue;
            return regTrace.type;
        }
        return null;
    }

    private static enum InstructionType {
        UNKNOWN_INSTRUCTION,
        REGCONST4,
        REGSTRINGCONST,
        REGSTRINGCONST_JUMBO,
        METHODINVOKE,
        METHODINVOKE_STATIC,
        QUICKMETHODINVOKE,
        INLINEMETHODINVOKE,
        INLINEMETHODINVOKE_RANGE,
        NEWARRAY,
        FILLARRAYDATA,
        ONEREGFIELD_READ,
        ONEREGFIELD_READ_WIDE,
        ONEREGFIELD_READ_OBJECT,
        ONEREGFIELD_WRITE,
        TWOREGSFIELD_READ,
        TWOREGSFIELD_READ_WIDE,
        TWOREGSFIELD_READ_OBJECT,
        TWOREGSFIELD_WRITE,
        NOPARAMETER,
        REGCONST16,
        REGCONST16_WIDE,
        THREEREGS,
        THREEREGS_WIDE,
        AGET,
        APUT,
        PACKEDSWITCH,
        SPARSESWITCH,
        ONEREG,
        MOVERESULT,
        OFFSET8,
        NEWINSTANCE,
        TWOREGSTYPE,
        REGOFFSET16,
        OFFSET16,
        TWOREGSOFFSET16,
        MOVE,
        MOVE_OBJECT,
        TWOREGSPACKED_SINGLE,
        TWOREGSPACKED_DOUBLE,
        TWOREGSCONST8,
        REGCLASSCONST,
        REGCONST32,
        REGCONST32_WIDE,
        REGCONST64,
        REG8REG16,
        REG8REG16_OBJECT,
        REG16REG16,
        REG16REG16_OBJECT,
        TWOREGSPACKEDCONST16,
        METHODINVOKE_RANGE,
        METHODINVOKE_RANGE_STATIC,
        QUICKMETHODINVOKE_RANGE,
        FILLEDARRAY,
        FILLEDARRAY_RANGE,
        TWOREGSQUICKOFFSET,
        TWOREGSQUICKOFFSET_WIDE,
        TWOREGSQUICKOFFSET_OBJECT,
        TWOREGSQUICKOFFSET_WRITE,
        CHECKCAST;

    }

    public static enum ForkStatus {
        CONTINUE,
        FORK_UNCONDITIONALLY,
        FORK_AND_CONTINUE,
        TERMINATE;

    }
}

