/*
 * Decompiled with CFR 0.152.
 */
package hu.uw.pallergabor.dedexer;

import hu.uw.pallergabor.dedexer.DexOptimizationData;
import hu.uw.pallergabor.dedexer.UnknownInstructionException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public abstract class DexParser {
    public static long odexOffset = 40L;
    RandomAccessFile file;
    protected PrintStream dump;
    private ArrayList<Integer> dumpStorage = new ArrayList(8);
    private long dumpBaseOffset = -1L;
    private boolean dumpOn = true;
    private DexOptimizationData dexOptimizationData = null;
    private static final String hexChars = "0123456789ABCDEF";

    public void setRandomAccessFile(RandomAccessFile file) {
        this.file = file;
    }

    public void setFilePosition(long position) throws IOException {
        this.file.seek(position);
    }

    public long getFilePosition() throws IOException {
        return this.file.getFilePointer();
    }

    public DexOptimizationData getDexOptimizationData() {
        return this.dexOptimizationData;
    }

    public void setDexOptimizationData(DexOptimizationData dexOptimizationData) {
        this.dexOptimizationData = dexOptimizationData;
    }

    public void setDumpFile(PrintStream dump) {
        this.dump = dump;
    }

    public void setDumpOn() {
        this.dumpOn = true;
    }

    public void setDumpOff() {
        this.dumpOn = false;
    }

    public int read8Bit() throws IOException {
        if (this.dumpBaseOffset < 0L) {
            this.dumpBaseOffset = this.file.getFilePointer();
        }
        int result = this.file.read();
        if (this.dumpOn) {
            this.dumpStorage.add(new Integer(result));
        }
        return result;
    }

    public int readSigned8Bit() throws IOException {
        int result = this.read8Bit();
        if ((result & 0x80) != 0) {
            result -= 256;
        }
        return result;
    }

    public int read16Bit() throws IOException {
        int result = this.read8Bit();
        return result |= this.read8Bit() << 8;
    }

    public long read32Bit() throws IOException {
        long result = this.read16Bit();
        return result |= (long)this.read16Bit() << 16;
    }

    public long readFileOffset() throws IOException {
        long r = this.read32Bit();
        return r == 0L ? 0L : r + this.getOdexOffset();
    }

    public int readSigned32Bit() throws IOException {
        int result = this.read16Bit();
        return result |= this.read16Bit() << 16;
    }

    public String readString() throws IOException {
        int c;
        long size = this.readVLN();
        long fpos = this.file.getFilePointer();
        int stringByteCount = 0;
        while ((c = this.read8Bit()) != 0) {
            ++stringByteCount;
        }
        byte[] stringBytes = new byte[stringByteCount];
        this.file.seek(fpos);
        for (int i = 0; i < stringByteCount; ++i) {
            stringBytes[i] = (byte)this.read8Bit();
        }
        this.read8Bit();
        String r = null;
        try {
            r = new String(stringBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        return r;
    }

    public long readVLN() throws IOException {
        int bitpos = 0;
        long vln = 0L;
        while (true) {
            int inp = this.read8Bit();
            vln |= (long)(inp & 0x7F) << bitpos;
            if ((inp & 0x80) == 0) break;
            bitpos += 7;
        }
        return vln;
    }

    public long readVLNWithLength(int bytes, boolean signed) throws IOException {
        long result = 0L;
        int b = 0;
        int bitpos = 0;
        int i = 0;
        while (i < bytes) {
            b = this.read8Bit();
            result |= (long)(b << bitpos);
            ++i;
            bitpos += 8;
        }
        if (signed && (b & 0x80) != 0) {
            for (i = bytes * 8; i < 64; i += 8) {
                result |= 255L << i;
            }
        }
        return result;
    }

    public long readFloatingPointVLNWithLength(int bytes) throws IOException {
        long result = 0L;
        int bitpos = 0;
        int i = 0;
        while (i < bytes) {
            int b = this.read8Bit();
            result |= (long)b << bitpos;
            ++i;
            bitpos += 8;
        }
        return result <<= (8 - bytes) * 8;
    }

    public long readSignedVLN() throws IOException {
        int inp;
        int bitpos = 0;
        long vln = 0L;
        do {
            inp = this.read8Bit();
            vln |= (long)(inp & 0x7F) << bitpos;
            bitpos += 7;
        } while ((inp & 0x80) != 0);
        if ((1L << bitpos - 1 & vln) != 0L) {
            vln -= 1L << bitpos;
        }
        return vln;
    }

    public long readFileOffsetVLN() throws IOException {
        long r = this.readVLN();
        return r == 0L ? 0L : r + this.getOdexOffset();
    }

    public void dump(String messageToDump) {
        if (this.dump == null) {
            return;
        }
        if (this.dumpOn && this.dumpBaseOffset >= 0L) {
            this.dump.print(this.dumpLong(this.dumpBaseOffset) + " ");
        }
        if (this.dumpOn && this.dumpStorage.size() > 0) {
            this.dump.print(":\t");
            for (int i = 0; i < this.dumpStorage.size(); ++i) {
                this.dump.print(this.dumpByte(this.dumpStorage.get(i)));
                this.dump.print(" ");
                if (i % 4 != 3) continue;
                this.dump.print("\n\t\t");
            }
            this.dumpStorage.clear();
            this.dumpBaseOffset = -1L;
        }
        this.dump.println(messageToDump);
    }

    public void parse(long pos) throws IOException, UnknownInstructionException {
        this.file.seek(pos);
        this.parse();
    }

    public abstract void parse() throws IOException, UnknownInstructionException;

    public int parseExpected8Bit(int expectedValue) throws IOException {
        int w = this.read8Bit();
        if (w != expectedValue) {
            throw new IOException("Value read: 0x" + this.dumpByte(w) + "; value expected: 0x" + this.dumpByte(expectedValue) + "; file offset: 0x" + this.dumpLong(this.file.getFilePointer() - 1L));
        }
        return w;
    }

    public int parseExpected8BitValues(int[] expectedValue) throws IOException {
        int w = this.read8Bit();
        for (int i = 0; i < expectedValue.length; ++i) {
            if (w != expectedValue[i]) continue;
            return i;
        }
        throw new IOException("Value read: 0x" + this.dumpByte(w) + "; value expected: " + this.dumpBytes(expectedValue) + "; file offset: 0x" + this.dumpLong(this.file.getFilePointer() - 1L));
    }

    public void parseExpected16Bit(int expectedValue) throws IOException {
        int w = this.read16Bit();
        if (w != expectedValue) {
            throw new IOException("Value read: 0x" + this.dumpWord(w) + "; value expected: 0x" + this.dumpWord(expectedValue) + "; file offset: 0x" + this.dumpLong(this.file.getFilePointer() - 2L));
        }
    }

    public void parseExpected32Bit(long expectedValue) throws IOException {
        long w = this.read32Bit();
        if (w != expectedValue) {
            throw new IOException("Value read: 0x" + this.dumpLong(w) + "; value expected: 0x" + this.dumpLong(expectedValue) + "; file offset: 0x" + this.dumpLong(this.file.getFilePointer() - 4L));
        }
    }

    public String dumpLong(long l) {
        StringBuilder b = new StringBuilder();
        this.to8DigitHexNumber(b, (int)(l & 0xFFFFFFFFL));
        return new String(b);
    }

    public String dumpWord(int word) {
        StringBuilder b = new StringBuilder();
        this.to4DigitHexNumber(b, word);
        return new String(b);
    }

    public String dumpByte(int b) {
        StringBuilder s = new StringBuilder();
        this.to2DigitHexNumber(s, b);
        return new String(s);
    }

    public String dumpBytes(int[] b) {
        StringBuilder s = new StringBuilder();
        s.append("[");
        for (int i = 0; i < b.length; ++i) {
            if (i > 0) {
                s.append(",");
            }
            s.append("0x");
            this.to2DigitHexNumber(s, b[i]);
        }
        s.append("]");
        return new String(s);
    }

    private void to8DigitHexNumber(StringBuilder buffer, int number) {
        this.to4DigitHexNumber(buffer, number >> 16);
        this.to4DigitHexNumber(buffer, number);
    }

    private void to4DigitHexNumber(StringBuilder buffer, int number) {
        this.to2DigitHexNumber(buffer, number >> 8);
        this.to2DigitHexNumber(buffer, number);
    }

    private void to2DigitHexNumber(StringBuilder buffer, int number) {
        buffer.append(this.to1DigitHexNumber(number >> 4));
        buffer.append(this.to1DigitHexNumber(number));
    }

    private char to1DigitHexNumber(int number) {
        int offset = number & 0xF;
        return hexChars.charAt(offset);
    }

    private long getOdexOffset() {
        if (this.dexOptimizationData == null) {
            return 0L;
        }
        return this.dexOptimizationData.getDexOffset();
    }
}

